

<?php $__env->startSection('title', 'News Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>News Management</h1>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create news')): ?>
            <a href="<?php echo e(route('admin.news.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus-circle"></i> Create News Article
            </a>
            <?php endif; ?>
        </div>
        <p>Manage your news articles</p>
    </div>
    
    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>News Articles</h3>
        </div>
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Author</th>
                            <th>Date</th>
                            <th>Reading Time</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($article->id); ?></td>
                            <td>
                                <?php if($article->image): ?>
                                    <img src="<?php echo e(Storage::url($article->image)); ?>" alt="<?php echo e($article->title); ?>" class="avatar-sm">
                                <?php else: ?>
                                    <i class="fas fa-newspaper"></i>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.news.show', $article)); ?>" class="thread-link">
                                    <?php echo e($article->title); ?>

                                </a>
                                <div class="thread-stats">
                                    <?php echo e(Str::limit($article->short_description, 50)); ?>

                                </div>
                            </td>
                            <td><?php echo e($article->author->name); ?></td>
                            <td><?php echo e($article->formatted_date); ?></td>
                            <td><?php echo e($article->reading_time); ?></td>
                            <td class="user-actions">
                                <a href="<?php echo e(route('admin.news.show', $article)); ?>" class="btn-icon btn-primary" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage news')): ?>
                                <a href="<?php echo e(route('admin.news.edit', $article)); ?>" class="btn-icon btn-success" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete news')): ?>
                                <form action="<?php echo e(route('admin.news.destroy', $article)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this news article?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn-icon btn-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">No news articles found</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-md">
                <?php echo e($news->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/news/index.blade.php ENDPATH**/ ?>